% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_methods.R, R/attrition.R, R/bind_keys.R,
%   R/source_tblist.R
\name{source-layer}
\alias{source-layer}
\alias{.init_step}
\alias{.init_step.default}
\alias{.collect_data}
\alias{.collect_data.default}
\alias{.get_stats}
\alias{.get_stats.default}
\alias{.pre_filtering}
\alias{.post_filtering}
\alias{.pre_filtering.default}
\alias{.post_filtering.default}
\alias{.get_attrition_label}
\alias{.get_attrition_label.default}
\alias{.get_attrition_count}
\alias{.get_attrition_count.default}
\alias{.run_binding}
\alias{.run_binding.default}
\alias{.init_step.tblist}
\alias{.collect_data.tblist}
\alias{.get_stats.tblist}
\title{Source compatibility methods.}
\usage{
.init_step(source, ...)

\method{.init_step}{default}(source, ...)

.collect_data(source, data_object)

\method{.collect_data}{default}(source, data_object)

.get_stats(source, data_object)

\method{.get_stats}{default}(source, data_object)

.pre_filtering(source, data_object, step_id)

.post_filtering(source, data_object, step_id)

\method{.pre_filtering}{default}(source, data_object, step_id)

\method{.post_filtering}{default}(source, data_object, step_id)

.get_attrition_label(source, step_id, step_filters, ...)

\method{.get_attrition_label}{default}(source, step_id, step_filters, ...)

.get_attrition_count(source, data_stats, ...)

\method{.get_attrition_count}{default}(source, data_stats, ...)

.run_binding(source, ...)

\method{.run_binding}{default}(source, binding_key, data_object_pre, data_object_post, ...)

\method{.init_step}{tblist}(source, ...)

\method{.collect_data}{tblist}(source, data_object)

\method{.get_stats}{tblist}(source, data_object)
}
\arguments{
\item{source}{Source object.}

\item{...}{Other parameters passed to specific method.}

\item{data_object}{Object that allows source data access.
`data_object` is the result of `.init_step` method (or object of the same structure).}

\item{step_id}{Name of the step visible in resulting plot.}

\item{step_filters}{List of step filters.}

\item{data_stats}{Data frame presenting statistics for each filtering step.}

\item{binding_key}{Binding key describing currently processed relation.}

\item{data_object_pre}{Object storing unfiltered data in the current step (previous step result).}

\item{data_object_post}{Object storing current data (including active filtering and previously done bindings).}
}
\value{
Depends on specific method. See `vignette("custom-extensions")` for more details.
}
\description{
List of methods that allow compatibility of different source types.
Most of the methods should be defined in order to make new source layer functioning.
See 'Details' section for more information.
}
\details{
The package is designed to make the functionality work with multiple data sources.
Data source can be based for example on list of tables, connection to database schema
or API service that allows to access and operate on data.
In order to make new source type layer functioning, the following list of methods
should be defined:
\itemize{
  \item{.init_source}{ Defines how to extract data object from source.
  Each filtering step assumes to be operating on resulting data object
  (further named data_object) and returns object of the same type and structure.}
  \item{.collect_data}{ Defines how to collect data (into R memory) from `data_object`.}
  \item{.get_stats}{ Defines what `data_object` statistics should be
  calculated and how. When provided the stats can be extracted using \link{stat}.}
  \item{.pre_filtering}{ (optional) Defines what operation on `data_object` should be
  performed before applying filtering in the step.}
  \item{.post_filtering}{ (optional) Defines what operation on `data_object` should be
  performed after applying filtering in the step.}
  \item{.run_binding}{ (optional) Defines how to handle post filtering data binding.
  See more about binding keys at \link{binding-keys}.}
  \item{.get_attrition_count and .get_attrition_label}{ Methods defining how to
  get statistics and labels for attrition plot.}
}
Except from the above methods, you may extend the existing or new source with providing
custom filtering methods. See \link{creating-filters}.
In order to see more details about how to implement custom source check `vignette("custom-extensions")`.
}
