% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort_methods.R, R/source_methods.R
\name{add_filter}
\alias{add_filter}
\alias{add_filter.Cohort}
\alias{add_filter.Source}
\title{Add filter definition}
\usage{
add_filter(x, filter, step_id, ...)

\method{add_filter}{Cohort}(x, filter, step_id, run_flow = FALSE, ...)

\method{add_filter}{Source}(x, filter, step_id, ...)
}
\arguments{
\item{x}{An object to add filter to.}

\item{filter}{Filter definition created with \link{filter}.}

\item{step_id}{Id of the step to add the filter to.
If missing, filter is added to the last step.}

\item{...}{Other parameters passed to specific S3 method.}

\item{run_flow}{If `TRUE`, data flow is run after the filter is added.}
}
\value{
Method dependent object (i.e. `Cohort` or `Source`) having filter added in selected step.
}
\description{
Add filter definition
}
\seealso{
\link{managing-cohort}, \link{managing-source}
}
