# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convolution of Gamma Distributions.
#'
#' Density, distribution function, and random generation for convolution of gamma
#' distributions. The distribution of the convolution of independent Gamma random
#' variables with different parameters
#' is \eqn{Y = X_{1} + ... + X_{n}}, where \eqn{X_{i}, i = 1, ..., n},
#' are independent Gamma distributions with parameters shapes and rates.
#' The density function and distribution function can be calculated, according to the
#' formulas from Moschopoulos, Peter G. (1985).
#'
#' @param x Quantiles.
#' @param n Number of sample.
#' @param shape Numerical vector of shape parameters of every gamma distributions,
#' all shape parameters >= 0, at least one shape parameter > 0.
#' @param rate Numerical vector of rate parameters of every gamma distributions,
#' all rate parameters > 0.
#'
#' @references
#' Moschopoulos, Peter G. "The distribution of the sum of independent
#' gamma random variables." Annals of the Institute of
#' Statistical Mathematics 37.1 (1985): 541-544.
#' @examples
#' set.seed(123)
#' ## do grid
#' y <- rcoga(100000, c(3,4,5), c(2,3,4))
#' grid <- seq(0, 15, length.out=100)
#' ## calculate pdf and cdf
#' pdf <- dcoga(grid, shape=c(3,4,5), rate=c(2,3,4))
#' cdf <- pcoga(grid, shape=c(3,4,5), rate=c(2,3,4))
#'
#' ## plot pdf
#' plot(density(y), col="blue")
#' lines(grid, pdf, col="red")
#'
#' ## plot cdf
#' plot(ecdf(y), col="blue")
#' lines(grid, cdf, col="red")
#'
#' @author Chaoran Hu
#'
#' @export
dcoga <- function(x, shape, rate) {
    .Call('coga_dcoga', PACKAGE = 'coga', x, shape, rate)
}

#' @rdname dcoga
#' @export
pcoga <- function(x, shape, rate) {
    .Call('coga_pcoga', PACKAGE = 'coga', x, shape, rate)
}

