% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyAnnotation.r
\name{annotateSeries}
\alias{annotateSeries}
\title{annotateSeries}
\usage{
annotateSeries(dygraph, series, x = 0, text = series, tooltip = series,
  width = 50, ...)
}
\arguments{
\item{dygraph}{Dygraph to add an annotation to}

\item{series}{Series to attach the annotation to. By default, the last series
defined using \code{\link{dySeries}}.}

\item{x}{Either numeric or date value indicating where to place the
annotation. For date value, this should be of class \code{POSIXct} or
convertible to \code{POSIXct}.}

\item{text}{Text to overlay on the chart at the location of x}

\item{tooltip}{Additional tooltip text to display on mouse hover}

\item{width}{Width (in pixels) of the annotation flag.}

\item{\dots}{Further arguments passed to \code{link[dygraphs]{dyAnnotation}}}
}
\description{
Annotate a series
}
\details{
A helper function that changes the order of some options for \code{link[dygraphs]{dyAnnotation}} so it is easier to use with \code{\link[purrr]{reduce}}.
}
\author{
Jared P. Lander
}
