% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk.R
\name{crosswalk}
\alias{crosswalk}
\title{crosswalk}
\usage{
crosswalk(x, from, to = "codemeta",
  codemeta_context = getOption("codemeta_context",
  "https://doi.org/10.5063/schema/codemeta-2.0"))
}
\arguments{
\item{x}{a JSON list or file with data fields to be crosswalked}

\item{from}{the corresponding column name from the crosswalk table.}

\item{to}{the column to translate into, assumes "codemeta" by default}

\item{codemeta_context}{the address or contents of codemeta context. Leave at default}
}
\value{
a `json` object containing a valid codemeta.json file created by crosswalking the input JSON
}
\description{
Crosswalk between different metadata fields used by different repositories,
registries and archives. For more details see https://codemeta.github.io/crosswalk
This function requires an internet connection to obtain the latest crosswalk table.
This function essentially applies the crosswalk table shown by \code{\link{crosswalk_table}}
to a given JSON metadata record.
}
\examples{
\dontrun{
## Crosswalk data returned by the GitHub API into CodeMeta format
r <- gh::gh("/repos/:owner/:repo", owner = "ropensci", repo = "EML")
crosswalk(r, "GitHub")
}

}
