test_that("independence test works with sequential evaluation", {
    require(gtools)
    require(future)
    set.seed(123)
    x <- rdirichlet(100, rep(1, 3))
    y <- rdirichlet(100, rep(1,3))
    p <- codalm_indep_test(y, x)
    expect_true(p > .05)
    expect_true(inherits(plan(), 'sequential'))
})
test_that("independence test works with multisession evaluation", {
    require(gtools)
    require(future)
    set.seed(123)
    x <- rdirichlet(100, rep(1, 3))
    y <- rdirichlet(100, rep(1,3))
    p <- codalm_indep_test(y, x, parallel = TRUE, strategy = 'multisession', ncpus = 2)
    expect_true(p > .05)
    expect_true(inherits(plan(), 'sequential'))
})

