% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_tools.R
\name{data_matrix_rmse}
\alias{data_matrix_rmse}
\title{Compute RMSE between data.matrices dm1 and dm2}
\usage{
data_matrix_rmse(dm1, dm2)
}
\arguments{
\item{dm1}{[N,M] numeric, First data.matrix}

\item{dm2}{[N,M] numeric, Second data.matrix}
}
\value{
[1,M] numeric, A vector of RMSE values, one per variable.
}
\description{
A data.matrix has observations as rows and variables as columns
}
\examples{
\dontrun{
 dm1 <- matrix(rep(1,6),nrow=2)
 dm2 <- matrix(rep(3,6),nrow=2)
 data_matrix_rmse(dm1, dm2)
 
 first = list(dm1, dm1)
 second = list(dm2, dm2)
 (tmp = mapply(data_matrix_rmse, first, second, SIMPLIFY=FALSE))
 }

}
