% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bal.tab.R
\name{print.bal.tab}
\alias{print.bal.tab}
\title{Print Results of a Call to \code{bal.tab()}}
\usage{
\method{print}{bal.tab}(
  x,
  imbalanced.only,
  un,
  disp.bal.tab,
  disp.call,
  stats,
  disp.thresholds,
  disp,
  which.subclass,
  subclass.summary,
  which.imp,
  imp.summary,
  imp.fun,
  which.treat,
  multi.summary,
  which.time,
  msm.summary,
  which.cluster,
  cluster.summary,
  cluster.fun,
  digits = max(3, getOption("digits") - 3),
  ...
)
}
\arguments{
\item{x}{a \code{bal.tab} object; the output of a call to \code{\link[=bal.tab]{bal.tab()}}.}

\item{imbalanced.only}{\code{logical}; whether to display only the covariates that failed to meet at least one of balance thresholds. Depends only on whether threshold were initial set in the call to \code{bal.tab()} and not on any arguments to \code{print()} (except \code{disp.bal.tab}).}

\item{un}{\code{logical}; whether to display balance values for the unadjusted sample. Ignored (and set to \code{TRUE}) if no conditioning was performed.}

\item{disp.bal.tab}{\code{logical}; whether to display the table of balance statistics. If \code{FALSE}, only other values (e.g., the call, sample sizes, balance tallies, and maximum imbalances) will be presented.}

\item{disp.call}{\code{logical}; whether to display the function call for the input object, if any.}

\item{stats}{\code{character}; which statistic(s) should be reported. For binary or multi-category treatments, the options are "mean.diffs" for mean differences (standardized or not according the selected \code{bal.tab()} options), "variance.ratios" for variance ratios, and "ks.statistics" for Kolmogorov-Smirnov statistics. "mean.diffs" is the default. For continuous treatments, the only option is "correlations" for treatment-covariate correlations. Multiple options are allowed. Abbreviations allowed. Statistics that weren't requested in the original call to \code{bal.tab()} cannot be requested with \code{print()} unless \code{quick = FALSE} in the original call.}

\item{disp.thresholds}{\code{logical}; whether to display thresholds for each statistic for which thresholds were originally requested in the call to \code{bal.tab()}. Should be a named logical vector with names corresponding to the thresholds. For example, if thresholds for mean differences were requested in \code{bal.tab()}, set \code{disp.thresholds = c(m = FALSE)} to prevent them from being printed. If a statistic was prevented from being displayed by another argument to \code{print()}, the thresholds will not be displayed.}

\item{disp}{\code{character}; which distribution summary statistics to display. Allowable options include "means" and "sds". Statistics that weren't requested in the original call to \code{bal.tab()} cannot be requested with \code{print()} unless \code{quick = FALSE} in the original call.}

\item{which.subclass}{when used with subclassification, which subclass(es) to display. If \code{NULL}, all subclasses will be displayed. If \code{NA}, no subclasses will be displayed. Otherwise, can be a vector of subclass indices for which to display balance. To display the subclasses requested in the original call to \code{bal.tab()}, omit this argument. See \code{\link{class-bal.tab.subclass}} for details.}

\item{subclass.summary}{\code{logical}; when used with subclassification, whether to display the subclass balance summary table. If \code{which.subclass} is \code{NA}, \code{subclass.summary} will be set to \code{TRUE}. See \code{\link{class-bal.tab.subclass}} for details.}

\item{which.imp}{when used with multiply imputed data, which imputation(s) to display. If \code{NULL}, all imputations will be displayed. If \code{NA}, no imputations will be displayed. Otherwise, can be a vector of imputations numbers for which to display balance. To display the imputations requested in the original call to \code{bal.tab()}, omit this argument. See \code{\link{class-bal.tab.imp}} for details.}

\item{imp.summary}{\code{logical}; when used with multiply imputed data, whether to display the imputation summary table. If \code{which.imp} is \code{NA}, \code{imp.summary} will be set to \code{TRUE}. See \code{\link{class-bal.tab.imp}} for details.}

\item{imp.fun}{\code{character}; when used with multiply imputed data, a character vector of functions of balance statistics to display when displaying balance across imputations. Can be "mean", "min", or "max". More than one are allowed. See \code{\link{class-bal.tab.imp}} for details.}

\item{which.treat}{when used with multi-category treatments, which treatments to display. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details.}

\item{multi.summary}{\code{logical}; when used with multi-category treatments, whether to display the balance summary table across pairwise comparisons. See \code{\link[=class-bal.tab.multi]{bal.tab.multi()}} for details.}

\item{which.time}{when used with longitudinal treatments, which time periods to display if longitudinal treatments are used. See \code{\link{class-bal.tab.msm}} for details.}

\item{msm.summary}{\code{logical}; when used with longitudinal treatments, whether to display the balance summary table across time periods. See \code{\link{class-bal.tab.msm}} for details.}

\item{which.cluster}{when used with clustered data, which cluster(s) to display. If \code{NULL}, all clusters will be displayed. If \code{NA}, no clusters will be displayed. Otherwise, can be a vector of cluster names or numerical indices for which to display balance. Indices correspond to the alphabetical order of cluster names. To display the clusters requested in the original call to \code{bal.tab()}, omit this argument. See \code{\link{class-bal.tab.cluster}} for details.}

\item{cluster.summary}{\code{logical}; when used with clustered data, whether to display the cluster summary table. If \code{which.cluster} is \code{NA}, \code{cluster.summary} will be set to \code{TRUE}. See \code{\link{class-bal.tab.cluster}} for details.}

\item{cluster.fun}{\code{character}; when used with clustered data, a character vector of functions of balance statistics to display when displaying balance across clusters. Can be "mean", "min", or "max". More than one are allowed. See \code{\link{class-bal.tab.cluster}} for details.}

\item{digits}{the number of digits to display.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Prints \code{bal.tab()} output in a clean way. Provides options for printing.
}
\details{
Simply calling \code{bal.tab()} will print its results, but it can be useful to store the results into an object and print them again later, possibly with different print options specified. The \code{print()} function automatically dispatches the correct method for the \code{bal.tab} object given.

Any parameter used in \code{bal.tab()} for calculations, such as \code{int}, \code{addl}, or \code{distance}, cannot be used with \code{print()}; only those parameters listed above, those that solely determine printing options, can be used. To change computation options, a new call to \code{bal.tab()} must be performed.

Prior versions of \code{print()} had separate methods for each \code{bal.tab} class. Now they are dispatched internally.
}
\note{
Unless \code{quick = FALSE} in the original call to \code{bal.tab()} (which is not the default), some values may not be calculated, in which case using \code{print()} will not display these values even when requested. For example, if \code{stats = "m"} and \code{quick = TRUE} in the original call to \code{bal.tab()} (the default for both), setting \code{stats = "ks"} in \code{print()} will not print the KS statistics because they were not calculated.
}
\examples{
\dontshow{if (requireNamespace("WeightIt", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("lalonde", package = "cobalt")

w.out <- WeightIt::weightit(treat ~ age + educ + married +
                                race + re74 + re75, 
                            data = lalonde)

b <- bal.tab(w.out, stats = c("m", "v", "ks"), 
             un = TRUE, v.threshold = 2)

print(b, un = FALSE, stats = c("m", "v"),
      disp.thresholds = c(v = FALSE))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=print]{print()}}, \code{\link[=bal.tab]{bal.tab()}}

\code{\link{display-options}} for further information on some of these options.
}
