% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_zero_inflation.R
\name{par_zero_inflation}
\alias{par_zero_inflation}
\title{Zero Inflation for Parameters}
\usage{
par_zero_inflation(par, prob, random = TRUE)
}
\arguments{
\item{par}{A parameter which will be set to 0 for part of the loci.}

\item{prob}{The probability that the parameters value will be set to `0`
for each locus if \code{random} is \code{TRUE}. Otherwise, it's the
fixed fraction of loci which will have a parameter value of `0`.}

\item{random}{Whether the number of loci which are simulated with a value of
`0` should be random (\code{TRUE}) or a fixed fraction (\code{FALSE}). See
\code{prob} for details.}
}
\description{
This adds a zero inflation to the distribution of a parameter for the
different loci. When using this, each locus will be simulated with a
parameter value of 0 with probability \code{prob}, or with parameter's
original value in the remaining cases.
are called separately for each locus, which can dramatically increase the
time needed to simulate models with many loci.
}
\examples{
# Simulate half of the loci with recomination and the other half without it:
model <- coal_model(4, 4) +
  feat_recombination(par_zero_inflation(par_named("rho"), .5, random = FALSE)) +
  sumstat_trees()
simulate(model, pars = c(rho = 1))

# Use a zero inflated gamma distribution:
model <- coal_model(4, 4) +
  feat_recombination(par_zero_inflation(par_variation(1, 10), .3)) +
  sumstat_trees()
simulate(model)
}
\seealso{
For parameters that are identical for all loci: \code{\link{parameter}}
}

