% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/parameter.R, R/parameter_prior.R
\name{par_expr}
\alias{par_const}
\alias{par_expr}
\alias{par_named}
\alias{par_prior}
\alias{par_range}
\alias{parameter}
\title{Define Model parameters}
\usage{
par_expr(expr)

par_const(constant)

par_named(name)

par_range(name, lower, upper)

par_prior(name, prior)
}
\arguments{
\item{expr}{An R expression.
This allows to define a parameter using an R expression.
It can contain other named parameters (e.g. \code{2 * a} will create an
parameter that is twice the value of an existing parameter \code{a}).
Make sure that the expression always evaluates
to a valid parameter value (a single numeric in almost all cases).}

\item{constant}{An R expression.
The constant value of the parameter.
Different to \code{expr}, the expression is evaluated immediately and
can not depend on other named parameters.}

\item{name}{Character. The name of the parameter. Must be unique in a model.}

\item{lower}{A numeric. The lower boundary of the parameter"s range.}

\item{upper}{A numeric. The upper boundary of the parameter"s range.}

\item{prior}{An expression. Evaluation this expression should give
a sample from the prior distribution you want for the parameter.
For example using \code{rnorm(1)} gives a standard normal prior.}
}
\description{
This functions allow to add parameters to a model. parameters can either
be used in features, or added directly to a model using the plus operator.
The value of parameters can be specified in the simulation command
(for \code{par_named} and \code{par_range}), sampled from a prior
distribution (\code{par_prior}) or can be derived from other parameters
(\code{par_expr}).
}
\section{Functions}{
\itemize{
\item \code{par_expr}: Creates a parameter with value determined by evaluating an
expression.

\item \code{par_const}: Creates an parameter that is equal to a fixed value.
Different to par_expr, the value is evaluated on parameter creation.

\item \code{par_named}: Creates an parameter whose value is specified via the
\code{pars} argument in \code{\link{simulate.coalmodel}}.

\item \code{par_range}: Creates an parameter that can take a range of possible
 values.
 Similar to \code{\link{par_named}}, the value of the parameter
 used in a simulation is set via the \code{pars} argument.
 This is primarily intended for creating model parameters for
 \pkg{jaatha}.

\item \code{par_prior}: Creates a named parameter with a prior
 distribution. Before each simulation, the expression for the prior
 is evaluated. The resulting value can be used in
 \code{\link{par_expr}} under the chosen name.
}}
\examples{
par_const(5)
par_named("x")
par_prior("y", rnorm(1))
par_range("z", 1, 5)
par_expr(2*x + y * z)
}
\author{
Paul Staab
}

