% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/locus.R
\name{locus_single}
\alias{locus_averaged}
\alias{locus_single}
\title{Add one locus or multiple loci to a Model}
\usage{
locus_single(length)

locus_averaged(number, length)
}
\arguments{
\item{length}{The length of the locus in base pairs.}

\item{number}{The number of loci to add.}
}
\description{
Add one locus or multiple loci to a Model
}
\section{Functions}{
\itemize{
\item \code{locus_averaged}: 
}}
\examples{
# A model with one locus of length 1005 bp
coal_model(5:7, 0) + locus_single(1005)

# A model with ten loci of average length 950bp
coal_model(15, 0) + locus_averaged(10, 950)
# or just
coal_model(15, 10, 950)

# A model with two loci. The first group consists of 10 loci with
# a length 560bp each, the second one of two loci with length 750bp and 560pb,
# respectively.
coal_model(20, 10, 560) +
  locus_single(750) +
  locus_single(430)
}

