% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tracts_variables_ref}
\alias{tracts_variables_ref}
\title{Reference table for tracts_to_* function variables}
\format{
A data frame with 22 rows and 4 columns:
\describe{
\item{var_cnefetools}{Variable name used in cnefetools functions.}
\item{code_var_ibge}{Official IBGE variable code from the census tract aggregates.}
\item{desc_var_ibge}{Official IBGE variable description in Portuguese.}
\item{table_ibge}{Name of the IBGE census tract table where the variable is found
(Domicilios, Pessoas, or ResponsavelRenda).}
}
}
\source{
IBGE - Censo Demografico 2022, Agregados por Setores Censitarios.
}
\usage{
tracts_variables_ref
}
\description{
A data frame that maps variable names used in \code{\link[=tracts_to_h3]{tracts_to_h3()}} and
\code{\link[=tracts_to_polygon]{tracts_to_polygon()}} to the official IBGE census tract dataset codes
and descriptions.
}
\examples{
# View the reference table
tracts_variables_ref

# Find the IBGE code for a specific variable
tracts_variables_ref[tracts_variables_ref$var_cnefetools == "pop_ph", ]

}
\keyword{datasets}
