% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timcumsum.R
\name{timcumsum}
\alias{timcumsum}
\title{Accumulate data of NetCDF file.}
\usage{
timcumsum(
  var,
  infile,
  outfile,
  nc34 = 4,
  overwrite = FALSE,
  na_replace = "mean",
  verbose = FALSE
)
}
\arguments{
\item{var}{Name of variable in infile (character).}

\item{infile}{Character containing file name or path of input file.}

\item{outfile}{Character containing file name or path of output file. If
NULL, the input file is directly edited instead.}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{Logical; should existing output file be overwritten? If
outfile is NULL, this parameter is ignored.}

\item{na_replace}{Replacing NA values with either 'mean' or 'previous' for monthly mean or previous value, respectively (character).}

\item{verbose}{logical; if TRUE, progress messages are shown}
}
\description{
Computes the accumulation of the given variable over time. The resulting outfile has the same dimensions as the infile.
}
