% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.R
\name{sa}
\alias{sa}
\alias{tspsa}
\title{Simulated annealing}
\usage{
sa(f, x, temp = 10000, rate = 1e-04)

tspsa(x, temp = 100, rate = 1e-04)
}
\arguments{
\item{f}{function representing \code{f}}

\item{x}{an initial estimate of the minimum}

\item{temp}{the initial temperature}

\item{rate}{the cooling rate}
}
\value{
the \code{x} value of the minimum found
}
\description{
Use simulated annealing to find the global minimum
}
\details{
Simulated annealing finds a global minimum by mimicing the
metallurgical process of annealing.
}
\examples{
f <- function(x) { x^6 - 4 * x^5 - 7 * x^4 + 22 * x^3 + 24 * x^2 + 2}
sa(f, 0)

f <- function(x) { (x[1] - 1)^2 + (x[2] - 1)^2 }
sa(f, c(0, 0), 0.05)

}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{goldsect}}, \code{\link{gradient}},
  \code{\link{hillclimbing}}, \code{\link{newton}},
  \code{\link{secant}}
}
