% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterlab.R
\name{clusterlab}
\alias{clusterlab}
\title{clusterlab}
\usage{
clusterlab(centers = 1, r = 8, sdvec = NULL, alphas = NULL,
  centralcluster = FALSE, numbervec = NULL, features = 500, seed = NULL,
  rings = NULL, ringalphas = NULL, ringthetas = NULL, outliers = NULL,
  outlierdist = NULL)
}
\arguments{
\item{centers}{Numerical value: the number of clusters to simulate (N)}

\item{r}{Numerical value: the number of units of the radius of the circle on which the clusters are generated}

\item{sdvec}{Numerical vector: standard deviation of each cluster, N values are required}

\item{alphas}{Numerical vector: how many units to push each cluster away from the initial placement, N values are required}

\item{centralcluster}{Logical flag: whether to place a cluster in the middle of the rest}

\item{numbervec}{Numerical vector: the number of samples in each cluster, N values are required}

\item{features}{Numerical value: the number of features for the data}

\item{seed}{Numerical value: fixes the seed if you want to repeat results, set the seed to 123 for example here}

\item{rings}{Numerical value: the number of concentric rings to generate (previous settings apply to all ring clusters)}

\item{ringalphas}{Numerical vector: a vector of numbers to push each ring out by, must equal number of rings}

\item{ringthetas}{Numerical vector: a vector of angles to rotate each ring by, must equal number of rings}

\item{outliers}{Numerical value: the number of outliers to create}

\item{outlierdist}{Numerical value: a distance value to move the outliers by}
}
\value{
A list, containing: 
1) the synthetic data
2) cluster membership matrix
}
\description{
This function runs clusterlab which is a simulator for Gaussian clusters. It is simple yet highly flexible allowing
the user to choose parameters such as the variance and size of each cluster individually. Clusterlab allows 
precise control over the distance between the N clusters.
}
\examples{
synthetic <- clusterlab(centers=4,r=8,sdvec=c(2.5,2.5,2.5,2.5),   
alphas=c(1,1,1,1),centralcluster=FALSE,   
numbervec=c(50,50,50,50)) # for a six cluster solution)   

}
