\name{resizeCLP}
\alias{resizeCLP}

\title{
  Resize a Model
}

\description{
  Low level interface function to the COIN-OR Clp function
  \code{Clp_resize}. Consult the COIN-OR Clp
  documentation for more detailed information.
}

\usage{
  resizeCLP(lp, nrows, ncols)
}

\arguments{
  \item{lp}{
    A pointer to a COIN-OR Clp problem object.
  }
  \item{nrows}{
    Number of rows.
  }
  \item{ncols}{
    Number of columns.
  }
}

\details{
  Interface to the C function \code{resize} which calls
  the COIN-OR Clp function \code{Clp_resize}.
  
  The function \code{resize} can produce a larger model.
  If the current number of rows and columns is \emph{n}
  and \emph{m} respectively and you set nrows to \emph{i}
  and ncols to \emph{j}, the new number of rows and columns
  will be \emph{i} and \emph{j}. It is not possible to
  scale down the model. In order to delete rows or columns,
  use \code{\link{delRowsCLP}} or \code{\link{delColsCLP}}.
}

\value{
  NULL
}

\references{
   The COIN-OR Clp home page at
   \url{http://www.coin-or.org/projects/Clp.xml}
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\seealso{
  \code{\link{delRowsCLP}} and \code{\link{delColsCLP}}.
}

\keyword{ optimize }

