/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.AwsClientConfigParamsFrame;
import com.norbl.cbp.ppe.gui.LabeledTextField;
import com.norbl.util.InaccessibleFileException;
import com.norbl.util.ParamHt;
import com.norbl.util.gui.GuiUtil;
import java.awt.EventQueue;
import java.io.IOException;

public class AwsClientConfigParams
extends ParamHt {
    public static final String ACC_CONFIG_FILENAME = ".ppe-aws-client-config";
    PPEManager ppeManager;

    public AwsClientConfigParams(PPEManager ppeManager) throws InaccessibleFileException, IOException {
        super(new String[0], ACC_CONFIG_FILENAME);
        this.ppeManager = ppeManager;
    }

    public ClientConfiguration buildClientConfiguration() {
        try {
            if (this.size() < 1) {
                return null;
            }
            ClientConfiguration cc = new ClientConfiguration();
            String errs = "";
            int nSet = 0;
            for (String key : this.keySet()) {
                String val = (String)this.get(key);
                try {
                    AccParam ap = AccParam.valueOf(key);
                    this.setParamVal(cc, ap, val);
                    ++nSet;
                }
                catch (IllegalArgumentException iax) {
                    errs = errs + iax.getMessage() + " ";
                }
                catch (RuntimeException rx) {
                    GuiUtil.exceptionMessageOnly(rx);
                }
            }
            if (nSet < 1) {
                return null;
            }
            if (errs.length() > 0) {
                GuiUtil.warning(new String[]{"Undefined parameters were found in the AWS client", " config file '.ppe-aws-client-config'", " ", errs.trim()}, "Undefined parameters");
            }
            return cc;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessageOnly(xxx);
            return null;
        }
    }

    public void editParams() {
        final AwsClientConfigParamsFrame f = new AwsClientConfigParamsFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                f.go();
            }
        });
        while (f.isActive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ix) {}
        }
        if (f.isCancelled()) {
            return;
        }
        for (LabeledTextField p : f.params) {
            String val = p.getVal();
            if (val != null && val.trim().length() < 1) {
                val = null;
            }
            this.put(p.getKey(), val);
        }
        this.saveAndReload();
    }

    private void setParamVal(ClientConfiguration cc, AccParam ap, String val) {
        switch (ap) {
            case ConnectionTimeout: {
                cc.setConnectionTimeout(Integer.parseInt(val));
                break;
            }
            case MaxConnections: {
                cc.setMaxConnections(Integer.parseInt(val));
                break;
            }
            case MaxErrorRetry: {
                cc.setMaxErrorRetry(Integer.parseInt(val));
                break;
            }
            case Protocol: {
                cc.setProtocol(Protocol.valueOf((String)val));
                break;
            }
            case ProxyDomain: {
                cc.setProxyDomain(val);
                break;
            }
            case ProxyHost: {
                cc.setProxyHost(val);
                break;
            }
            case ProxyPassword: {
                cc.setProxyPassword(val);
                break;
            }
            case setProxyPort: {
                cc.setProxyPort(Integer.parseInt(val));
                break;
            }
            case setProxyUsername: {
                cc.setProxyUsername(val);
                break;
            }
            case setProxyWorkstation: {
                cc.setProxyWorkstation(val);
                break;
            }
            case SocketTimeout: {
                cc.setSocketTimeout(Integer.parseInt(val));
                break;
            }
            case UserAgent: {
                cc.setUserAgent(val);
                break;
            }
        }
    }

    public static String getGuiText() {
        return "<html><body>If you access the internet through a proxy server, you <i>may</i> need to set some Amazon client configuration parameters before you can communicate with AWS and launch ec2 instances. See Amazon's documentation for details.</a><br><br>The values you enter below will be stored in a config file named<blockquote>.ppe-aws-client-config</blockquote>in your home directly and will be used whenever you launch a network. You can leave irrelevant fields blank.</body></html>";
    }

    public static enum AccParam {
        ConnectionTimeout,
        MaxConnections,
        MaxErrorRetry,
        Protocol,
        ProxyDomain,
        ProxyHost,
        ProxyPassword,
        setProxyPort,
        setProxyUsername,
        setProxyWorkstation,
        SocketTimeout,
        UserAgent;

    }
}

