/*
 * Decompiled with CFR 0.152.
 */
package ppe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import nbl.utilj.GuiUtil;
import nbl.utilj.SysProp;
import ppe.Constants;
import ppe.InaccessibleFileException;

public class ParamHt
extends HashMap<String, String> {
    public File configFile;

    public ParamHt(String[] argv) throws InaccessibleFileException, IOException {
        String configFilePath = ParamHt.getDefaultConfigFilePath();
        this.setConfigFile(configFilePath);
        String configFilename = this.getVal(argv, ParamName.configFile);
        if (configFilename != null) {
            this.setConfigFile(configFilename);
        }
        if (this.configFile != null && this.configFile.exists()) {
            this.recordParams(this.getParamsFromConfigFile());
        }
        if (argv != null && argv.length > 0) {
            this.recordParams(argv);
        }
        if (this.configFile != null) {
            this.put(this.configFile.toString().toLowerCase(), this.configFile.getPath());
        }
    }

    public void updateParams() {
        try {
            if (this.configFile != null && this.configFile.exists()) {
                this.recordParams(this.getParamsFromConfigFile());
            } else {
                GuiUtil.warning((String[])new String[]{"There is no param file, so params cannot be update.", "Edit the ec2 params (Edit -> Ec2 parameters"}, (String)"No param file");
            }
        }
        catch (Exception x) {
            GuiUtil.exceptionMessage((Throwable)x);
        }
    }

    public String getValue(String key) {
        return (String)this.get(key.toLowerCase());
    }

    public String setValue(String key, String value) {
        return this.put(key.toLowerCase(), value);
    }

    public static String getDefaultConfigFilePath() {
        return SysProp.user_home.getVal() + "/" + Constants.CONFIG_FILE_NAME;
    }

    private String getVal(String[] argv, ParamName par) {
        String ps = par.toString().toLowerCase() + "=";
        for (String arg : argv) {
            String[] a;
            if (!arg.toLowerCase().startsWith(ps) || (a = arg.split("=")) == null && a.length != 2) continue;
            return a[1];
        }
        return null;
    }

    private void setConfigFile(String path) throws InaccessibleFileException {
        File f = new File(path);
        if (f.exists() && !f.isDirectory()) {
            if (f.canRead()) {
                this.configFile = f;
            } else {
                throw new InaccessibleFileException("The config file " + f.getPath() + " exists but is not readable by this application.");
            }
        }
    }

    private String[] getParamsFromConfigFile() throws IOException {
        BufferedReader buffy = new BufferedReader(new FileReader(this.configFile));
        ArrayList<String> lst = new ArrayList<String>();
        String ln = null;
        while ((ln = buffy.readLine()) != null) {
            String pair = ln.trim();
            if (pair.startsWith("#") || !pair.contains("=")) continue;
            lst.add(pair);
        }
        return lst.toArray(new String[lst.size()]);
    }

    void recordParams(String[] argv) {
        if (argv == null) {
            return;
        }
        for (String arg : argv) {
            String[] a = arg.split("=");
            if (a == null || a.length != 2) continue;
            this.setValue(a[0], a[1]);
        }
    }

    public static enum ParamName {
        configFile;

    }
}

