% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_group}
\alias{date_group}
\title{Group date and date-time components}
\usage{
date_group(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the input used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x}, grouped at \code{precision}.
}
\description{
\code{date_group()} groups by a single component of a date-time, such as month
of the year, or day of the month.

There are separate help pages for grouping dates and date-times:
\itemize{
\item \link[=date-group]{dates (Date)}
\item \link[=posixt-group]{date-times (POSIXct/POSIXlt)}
}
}
\examples{
# See type specific documentation for more examples
date_group(as.Date("2019-01-01") + 0:5, "day", n = 2)
}
