% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoned-time.R
\name{as_zoned_time}
\alias{as_zoned_time}
\title{Convert to a zoned-time}
\usage{
as_zoned_time(x, ...)
}
\arguments{
\item{x}{\verb{[object]}

An object to convert to a zoned-time.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A zoned-time vector.
}
\description{
\code{as_zoned_time()} converts \code{x} to a zoned-time. You generally convert
to a zoned time from either a sys-time or a naive time. Each are documented
on their own page:
\itemize{
\item \link[=as-zoned-time-sys-time]{sys-time}
\item \link[=as-zoned-time-naive-time]{naive-time}
}

There are also convenience methods for converting to a zoned time from
native R date and date-time types:
\itemize{
\item \link[=as-zoned-time-Date]{dates (Date)}
\item \link[=as-zoned-time-posixt]{date-times (POSIXct / POSIXlt)}
}
}
\examples{
x <- as.Date("2019-01-01")
as_zoned_time(x)

y <- as_naive_time(year_month_day(2019, 2, 1))
as_zoned_time(y, zone = "America/New_York")
}
