% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_cdfs.R
\name{gev_cdf}
\alias{gev_cdf}
\title{Generalized Extreme Value (GEV) link CDF}
\usage{
gev_cdf(x, xi)
}
\arguments{
\item{x}{Numeric vector}

\item{xi}{Shape parameter}
}
\value{
CDF values
}
\description{
F(x; xi) = exp(-(1 + xi * x)^(-1/xi))
}
\details{
Special cases:
\itemize{
\item xi = 0: Gumbel (equals loglog)
\item xi < 0: Weibull (bounded above)
\item xi > 0: Frechet (heavy tail)
}

Reference: Wang & Dey (2011)
}
\keyword{internal}
