% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdm.fig.R
\name{cdm.fig}
\alias{cdm.fig}
\title{Central data monitoring to assess deviations (cdm.fig)}
\usage{
cdm.fig(df, col, site, meta_title, seedno, output, nmin)
}
\arguments{
\item{df}{dateframe to be assessed for missing data}

\item{col}{column to be assessed}

\item{site}{column with sites}

\item{meta_title}{Y-axis lab, if empty then it is the column name}

\item{seedno}{the numeric site, if empty it is just \code{Sys.Date()}}

\item{output}{if 'fig' then the figure is the output, any other will output
the blinded site table}

\item{nmin}{minimum number of variables in site to be presented}
}
\value{
Returns a full markdown output.
}
\description{
\code{cdm.fig()} is a function to assess any deviations
}
\examples{
\dontrun{
   cdm.fig(df,col="Mode of birth",
      site="maternal_trial_site")
   cdm.fig(df,col="Gestational Age at birth",
      site="maternal_trial_site")
   library(knitr)
   kable(cdm.fig(df,col="Mode of birth",
      site="maternal_trial_site",output = ""),row.names=F)
}

}
