% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recol.R
\name{recol}
\alias{recol}
\title{Reorder column (recol)}
\usage{
recol(df, old, new, factors=NULL, remove=TRUE, na=NA)
}
\arguments{
\item{df}{dataframe. (\code{df})}

\item{old}{old column name. (\code{string})}

\item{new}{new column name. (\code{string})}

\item{factors}{Named list of factors. If no names then just in alphabetical order (\verb{named list})}

\item{remove}{remove old column from dataframe (\code{boolian})}

\item{na}{the na.strings (\code{list})}
}
\value{
Returns the dataframe with new columns.
}
\description{
\code{recol()} is a small function which can rename columns and change factors to relevant input
}
\examples{
\dontrun{
   # NUMERIC VARIABLE
   df <- recol(df, "X5d_55_Alcohol_127", "Alcohol")
   # FACTOR VARIABLE
   df <- recol(df, "X5d_55_Alcohol_127", "Alcohol", factors=c("No","Yes"))
}

}
