% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrGcomp.R
\name{rrGcomp}
\alias{rrGcomp}
\alias{print.rrGcomp}
\title{Relative risk derived by G-computation (rrGcomp)}
\usage{
rrGcomp(df, outcome_col, group_col,
fixed_strata = NULL, random_strata = NULL,
nbrIter = 5000, conf_level = 0.95)
}
\arguments{
\item{df}{the individual participant dataframe}

\item{outcome_col}{column name for the outcome column}

\item{group_col}{column name for the group column}

\item{fixed_strata}{list of column names for the fixed effect stratification columns}

\item{random_strata}{list of column names for the random effect stratification columns}

\item{nbrIter}{number of iterations to be used in the G-computation. The original paper used 5000, which is also the default.}

\item{conf_level}{the confidence level to be reported.}
}
\value{
Returns a list with relative risk (rr), simulated rr (simRR), lower- and upper confidence level (simLCL/simUCL), and the p-value (p_val)
}
\description{
\code{rrGcomp()} is a small function which generates population-level (marginal) relative risks derived by G-computation. For models with random effects mixed-effects generalized linear model with a logit link with adjustment for stratification variables will be used, while those without random effects a logistic regression will be used. The code is based on the method used in the paper by Dankiewicz et al. (2021) N Engl J Med. Jun 17;384(24):2283-2294. (\href{https://pubmed.ncbi.nlm.nih.gov/34133859/}{PubMed}
}
\examples{
df <- sRCT(n_sites=3,n_pop=50)
rrGcomp(df,"outcome","Var1","age","site",10)

}
