% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OR_table.R
\name{ortable}
\alias{ortable}
\title{Logistic regression table with Odds ratio (ortable)}
\usage{
ortable(x, d, d_p, intercept, simple)
}
\arguments{
\item{x}{Utlises the output from a glm-function. (\code{glm-output})}

\item{d}{Refers to the number of digits for odds ratio and confidence intervals. Default is \code{2}. (\code{numeric})}

\item{d_p}{Refers to the number of digits for odds ratio and confidence intervals. Default is \code{3}. (\code{numeric})}

\item{intercept}{The intercept is presented in the table if \code{TRUE}. Default is \code{FALSE}. (\code{boolian})}

\item{simple}{Odds ratio and confidence intervals are merged into one column if \code{TRUE}. Default is \code{TRUE}. (\code{boolian})}
}
\value{
Returns a dataframe with with odds ratio,
confidence limits, and p-values.
}
\description{
\code{ortable()} is a small function which utilises the output from the glm-function to print a dataframe with odds ratio, confidence limits, and p-values.
}
\examples{
df <- data.frame(outcome=sample(0:1, 100,replace=TRUE),
        var=sample(0:100,100,replace=TRUE))
ortable(glm(outcome ~ ., data=df))

}
