% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_to_ss.R
\name{time_to_ss}
\alias{time_to_ss}
\title{Time to steady state
In either time units or number of doses}
\usage{
time_to_ss(kel = NULL, halflife = NULL, ss = 0.9, in_doses = FALSE, tau = NULL)
}
\arguments{
\item{kel}{drug elimination rate}

\item{halflife}{halflife. Either `kel` or `halflife` is required.}

\item{ss}{level considered "steady state", e.g. `0.9` is 90\% of true steady state.}

\item{in_doses}{return the number of doses instead of time unit? Default `FALSE`. Requires `tau` as well.}

\item{tau}{dosing interval}
}
\description{
Time to steady state
In either time units or number of doses
}
\examples{
time_to_ss(halflife = 12, ss = 0.9)
time_to_ss(halflife = 16, ss = 0.95, in_doses = TRUE, tau = 12)
}
