% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_2cmt_bolus_dose_from_cmin.R
\name{pk_2cmt_bolus_dose_from_cmin}
\alias{pk_2cmt_bolus_dose_from_cmin}
\title{Calculate dose to achieve steady state trough
for 2-compartmental PK model bolus dosing at steady state}
\usage{
pk_2cmt_bolus_dose_from_cmin(
  cmin = 1,
  tau = 12,
  CL = 3,
  V = 30,
  Q = 2,
  V2 = 20
)
}
\arguments{
\item{cmin}{desired trough concentration}

\item{tau}{dosing interval}

\item{CL}{clearance}

\item{V}{volume of distribution}

\item{Q}{inter-compartimental clearance}

\item{V2}{volume of peripheral compartment}
}
\description{
Calculate dose to achieve steady state trough
for 2-compartmental PK model bolus dosing at steady state
}
\examples{
dos <- pk_2cmt_bolus_dose_from_cmin(
  cmin = 5, tau = 12,
  CL = 5, V = 50, Q = 20, V2 = 200)
find_nearest_dose(dos, 100)
}
