% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdelta.R
\name{plotdelta}
\alias{plotdelta}
\title{Plot deltaAICc of models}
\usage{
plotdelta(dataset, arrow = FALSE, plotall = FALSE, plotallenv)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate 
windows. Output from \code{\link{slidingwin}}.}

\item{arrow}{TRUE or FALSE. Add arrows to plots to pinpoint best window.}

\item{plotall}{Used in conjunction with function \code{\link{plotall}}. 
Should not be changed manually.}

\item{plotallenv}{Used in conjunction with function \code{\link{plotall}}.
Should not be changed manually.}
}
\value{
Returns a colour plot of model deltaAICc values (larger negative
values indicate stronger models). DeltaAICc is the difference between AICc
of each climate window and a null model.
}
\description{
Create a colour plot of model deltaAICc values.
}
\examples{
# Plot deltaAICc estimates for climate windows in the Mass dataset

data(MassOutput)

plotdelta(dataset = MassOutput)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

