% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/autowin.R
\name{autowin}
\alias{autowin}
\title{Test for auto-correlation in climate.}
\usage{
autowin(reference, xvar, cdate, bdate, baseline, furthest, closest, stat, func,
  type, cutoff.day, cutoff.month, cmissing = FALSE, cinterval = "day",
  upper = NA, lower = NA, thresh = FALSE, centre = NULL)
}
\arguments{
\item{reference}{Reference climate data to be compared. Generated by functions
\code{\link{singlewin}} or \code{\link{climatewin}}.}

\item{xvar}{The climate variable of interest. Please specify the parent
environment and variable name (e.g. Climate$Temp).}

\item{cdate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{bdate}{The biological date variable (dd/mm/yyyy). Please specify the
parent environment and variable name (e.g. Biol$Date).}

\item{baseline}{The baseline model used to fit climate windows. These will be
correlated with the reference climate window.}

\item{furthest}{The furthest number of time intervals (set by cinterval) back
from the cutoff date or biological record to include in the climate window
search.}

\item{closest}{The closest number of time intervals (set by cinterval) back
from the cutoff date or biological record to include in the climate window
search.}

\item{stat}{The aggregate statistic used to analyse the climate data. Can
currently use basic R statistics (e.g. mean, min), as well as slope.
Additional aggregate statistics can be created using the format function(x)
(...). See parameter FUN in \code{\link{apply}} for more detail.}

\item{func}{The function used to fit the climate variable. Can be linear
("lin"), quadratic ("quad"), cubic ("cub"), inverse ("inv") or log ("log").
Not required when a variable is provided for parameter 'centre'.}

\item{type}{fixed or variable, whether you wish the climate window to be variable
(e.g. the number of days before each biological record is measured) or fixed
(e.g. number of days before a set point in time).}

\item{cutoff.day,cutoff.month}{If type is fixed, the day and month of the
year from which the fixed window analysis will start.}

\item{cmissing}{TRUE or FALSE, determines what should be done if there are
missing climate data. If FALSE, the function will not run if missing climate
data is encountered. If TRUE, any records affected by missing climate data
will be removed from climate window analysis.}

\item{cinterval}{The resolution at which climate window analysis will be
conducted. May be days ("day"), weeks ("week"), or months ("month"). Note the units
of parameters 'furthest' and 'closest' will differ with the choice of
cinterval.}

\item{upper}{Cut-off value used to determine growing degree days or positive
climate thresholds (depending on parameter thresh). Note that when values
of lower and upper are both provided, autowin will instead calculate an
optimal climate zone.}

\item{lower}{Cut-off value used to determine chill days or negative
climate thresholds (determined by parameter thresh). Note that when values
of lower and upper are both provided, autowin will instead calculate an
optimal climate zone.}

\item{thresh}{TRUE or FALSE. Determines whether to use values of upper and
lower to calculate binary climate data (thresh = TRUE), or to use for
growing degree days (thresh = FALSE).}

\item{centre}{Variable used for mean centring (e.g. Year, Site, Individual).
Please specify the parent environment and variable name (e.g. Biol$Year).}
}
\value{
Will return a data frame showing the correlation between the climate
 in each fitted window and the chosen reference window.
}
\description{
Tests the correlation between the climate in a specified climate window and
other fitted climate windows.
}
\examples{
\dontrun{

# Test for auto-correlation using 'Mass' and 'MassClimate' data frames

data(Mass)
data(MassClimate)

# Fit a single climate window using the datasets Mass and MassClimate.

single <- singlewin(xvar = list(Temp = MassClimate$Temp),
                    cdate = MassClimate$Date, bdate = Mass$Date,
                    baseline = lm(Mass ~ 1, data = Mass),
                    furthest = 72, closest = 15,
                    stat = "mean", func = "lin", type = "fixed",
                    cutoff.day = 20, cutoff.month = 5,
                    cmissing = FALSE, cinterval = "day")

# Test the autocorrelation between the climate in this single window and other climate windows.

auto <- autowin(reference = single$BestModelData$climate,
                xvar  = list(Temp = MassClimate$Temp), cdate = MassClimate$Date, bdate = Mass$Date,
                baseline = lm(Mass ~ 1, data = Mass), furthest = 365, closest = 0,
                stat = "mean", func = "lin",
                type = "fixed", cutoff.day = 20, cutoff.month = 5,
                cmissing = FALSE, cinterval = "day")

# View the output
head(auto)

# Plot the output
plotcor(auto, type = "A")
}
}
\author{
Liam D. Bailey and Martijn van de Pol
}

