% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/return_calcs.R
\name{calc_returnValueDiff_fevd}
\alias{calc_returnValueDiff_fevd}
\title{Calculates return value difference for two sets of covariates and standard error of difference given return period(s) of interest}
\usage{
calc_returnValueDiff_fevd(fit, returnPeriod, covariates1, covariates2,
  getSE = TRUE)
}
\arguments{
\item{fit}{fitted object from \pkg{extRemes} \code{fevd}}

\item{returnPeriod}{value(s) for which return value difference is desired}

\item{covariates1}{matrix of covariate values, each row a set of covariates for which the return value difference relative to the corresponding row of \code{covariates2} is desired}

\item{covariates2}{matrix of covariate values, each row a set of covariates}

\item{getSE}{logical indicating whether standard error is desired, in addition to the point estimate}
}
\description{
Calculates difference in return values (also known as return levels) for two sets of covariates given return period(s) of interest, using model fit from \code{extRemes::fevd}. Standard error is obtained via the delta method. The return value is the value for which the expected number of blocks until an event that exceeds that value is equal to the return period. Differences and standard errors are returned for as many contrasts between covariate sets as provided.
}
\details{
This is designed to calculate differences in return values and associated standard errors for different covariate values based on the same model fit. It is not designed for differences based on separate model fits, although it may be possible handle this case by fit two models in a single model specification using dummy variables.
}

