% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclimate.R
\name{bioclimate}
\alias{bioclimate}
\title{Holdridge points}
\usage{
bioclimate(temp, prec)
}
\arguments{
\item{temp}{A matrix or data frame with 12 columns containing
temperatures, in degrees C, for each month of the calendar year.}

\item{prec}{A matrix or data frame with the same dimensions as \code{temp},
containing precipitation measurements in mm for each month of the year.}
}
\value{
\code{bioclimate()} returns a data.frame whose columns
correspond to:
\itemize{
\item \code{abt}, mean annual biotemperature; mean annual temperature after
replacing entries outside the range 0° to 30° with zeros;
\item \code{tap}, total annual precipitation (mm);
\item \code{per}, potential evapotranspiration ratio
}
}
\description{
Calculates the values of bioclimatic indices from monthly temperature and
precipitation measurements, following Szelepcsényi et al. 2014.
}
\references{
Szelepcsényi Z, Breuer H, Sümegi P (2014)
The climate of Carpathian Region in the 20th century based on the original
and modified Holdridge life zone system.
\emph{Cent Eur J Geosci} 6, 293–307. \doi{10.2478/s13533-012-0189-5}

Holdridge L. R. (1959) Simple method for determining potential
evapotranspiration from temperature data. \emph{Science}, 130, 572.
\doi{10.1126/science.130.3375.572}
}
\author{
Martin R. Smith
}
