% Generated by roxygen2 (4.0.2): do not edit by hand
\name{climdex.dtr}
\alias{climdex.dtr}
\title{Mean Diurnal Temperature Range}
\usage{
climdex.dtr(ci, freq = c("monthly", "annual"))
}
\arguments{
\item{ci}{Object of type climdexInput.}

\item{freq}{Time frequency to aggregate to.}
}
\value{
A vector containing the mean monthly or mean annual diurnal
temperature range.
}
\description{
This function computes the diurnal temperature range on a monthly basis.
}
\details{
\code{climdex.dtr} computes the mean daily diurnal temperature range. The
frequency of observation can be either monthly or annual.
}
\note{
This function creates results which may differ in the 3rd decimal
place from the results from fclimdex.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create a monthly timeseries of mean diurnal temperature range.
dtr <- climdex.dtr(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

