% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_api_key.R
\name{aemet_api_key}
\alias{aemet_api_key}
\title{Install an AEMET API Key}
\usage{
aemet_api_key(apikey, overwrite = FALSE, install = FALSE)
}
\arguments{
\item{apikey}{The API key provided to you from the AEMET formatted in quotes.
A key can be acquired at
\url{https://opendata.aemet.es/centrodedescargas/inicio}.}

\item{overwrite}{If this is set to \code{TRUE}, it will overwrite an existing
AEMET_API_KEY that you already have in local machine.}

\item{install}{if \code{TRUE}, will install the key in your local machine for
use in future sessions.  Defaults to \code{FALSE.}}
}
\value{
None
}
\description{
This function will store your AEMET API key on your local machine so it can
be called securely without being stored in your code. After you have
installed your key, it can be called any time by typing
\code{Sys.getenv("AEMET_API_KEY")} and can be
used in package functions by simply typing \code{AEMET_API_KEY}.

Alternatively, you can install the API Key manually:
\itemize{
\item Run \code{Sys.setenv(AEMET_API_KEY = "Your_Key")}. You would need to run this
command on each session (Similar to \code{install = FALSE}).
\item Write this line on your .Renviron file: \code{AEMET_API_KEY = "Your_Key"} (
same behavior than \code{install = TRUE}). This would store your API key
permanently.
}
}
\note{
To locate your API Key on your local machine, run
\code{rappdirs::user_cache_dir("climaemet", "R")}.
}
\examples{
# Don't run these examples!

if (FALSE) {
  aemet_api_key("111111abc", install = TRUE)

  # You can check it with:
  Sys.getenv("AEMET_API_KEY")
}

if (FALSE) {
  # If you need to overwrite an existing key:
  aemet_api_key("222222abc", overwrite = TRUE, install = TRUE)

  # You can check it with:
  Sys.getenv("AEMET_API_KEY")
}
}
\seealso{
Other aemet_auth: 
\code{\link{aemet_detect_api_key}()}
}
\concept{aemet_auth}
