% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfUser.R
\name{cf_curl_opts}
\alias{cf_curl_opts}
\title{Store curl options for use within \pkg{clifro}}
\usage{
cf_curl_opts(..., .opts = list())
}
\arguments{
\item{...}{a name-value pairs that are passed to \code{\link[RCurl]{curlOptions}}}

\item{.opts}{a named list or \code{CURLOptions} object that are passed to \code{\link[RCurl]{curlOptions}}}
}
\description{
The \code{cf_curl_opts} function stores specific curl options that are used
for all the \pkg{clifro} queries.
}
\examples{
\dontrun{
# Specify options for use in all the curl handles created in clifro
cf_curl_opts(.opts = list(proxy = "http://xxxxx.yyyy.govt.nz:8080",
                          proxyusername  = "uid",
                          proxypassword  = "pwd",
                          ssl.verifypeer = FALSE))
# Or alternatively:
cf_curl_opts(proxy = "http://xxxxx.yyyy.govt.nz:8080",
             proxyusername  = "uid",
             proxypassword  = "pwd",
             ssl.verifypeer = FALSE)
}
}
