% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findStations.R
\name{cf_find_station}
\alias{cf_find_station}
\title{Search for Clifro Stations}
\usage{
cf_find_station(..., search = c("name", "region", "network", "latlong"),
  datatype, combine = c("all", "any"), status = c("open", "closed", "all"))
}
\arguments{
\item{...}{arguments to pass into the search, these differ depending on
\code{search}.}

\item{search}{one of \code{name}, \code{network}, \code{region} or
\code{latlong} indicating the type of search to be conducted.}

\item{datatype}{\code{cfDatatype} object for when the search is based on
datatypes.}

\item{combine}{character string \code{"all"} or \code{"any"} indicating if the
stations contain all or any of the selected datatypes for when the search is
based on datatypes.}

\item{status}{character string indicating \code{"open"}, \code{"closed"} or
\code{"all"} stations be returned by the search.}
}
\value{
\code{cfStation} object
}
\description{
Search for \pkg{clifro} stations based on name, region, location or network
number, and return a \code{cfStation} object.
}
\details{
The \code{cf_find_station} function is a convenience function for finding
CliFlo stations in \R. It uses the CliFlo
\href{https://cliflo.niwa.co.nz/pls/niwp/wstn.get_stn_html}{Find Stations}
page to do the searching, and therefore means that the stations are not
stored within \pkg{clifro}.

If \code{datatype} is missing then the search is conducted
without any reference to datatypes. If it is supplied then the
search will only return stations that have any or all of the supplied
datatypes, depending on \code{combine}. The default behaviour is to search
for stations based on pattern matching the station name and return only the
open stations.

If the \code{latlong} search type is used the function expects named
arguments with names (partially) matching latitude,
longitude and radius. If the arguments are passed in without names they must
be in order of latitude, longitude and radius (see examples).
}
\note{
Since the searching is done by CliFlo there are obvious restrictions.
Unfortunately the pattern matching for station name does not provide
functionality for regular expressions, nor does it allow simultaneous
searches although \pkg{clifro} does provide some extra functionality, see
the 'OR query Search' example below.
}
\examples{
\dontrun{
# Station Name Search ------------------------------------------------------
# Return all open stations with 'island' in the name (pattern match search)
# Note this example uses all the defaults

island_st = cf_find_station("island")
island_st

# Region Search ------------------------------------------------------------
# Return all the closed stations from Queenstown (using partial matching)

queenstown.st = cf_find_station("queen", search = "region", status = "closed")
queenstown.st

# Long/Lat Search ----------------------------------------------------------
# Return all open stations within a 10km radius of the Beehive in Wellington
# From Wikipedia: latitude 41.2784 S, longitude 174.7767 E

beehive.st = cf_find_station(lat = -41.2784, long = 174.7767, rad = 10,
                             search = "latlong")
beehive.st

# Network ID Search --------------------------------------------------------
# Return all stations that share A42 in their network ID

A42.st = cf_find_station("A42", search = "network", status = "all")
A42.st

# Using Datatypes in the Search --------------------------------------------
# Is the Reefton EWS station open and does it collect daily rain and/or wind
# data?

# First, create the daily rain and wind datatypes
daily.dt = cf_datatype(c(2, 3), c(1, 1), list(4, 1), c(1, NA))
daily.dt

# Then combine into the search. This will only return stations where at least
# one datatype is available.
cf_find_station("reefton EWS", datatype = daily.dt)  # Yes

# OR Query Search ----------------------------------------------------------
# Return all stations sharing A42 in their network ID *or* all the open
# stations within 10km of the Beehive in Wellington (note this is not
# currently available as a single query in CliFlo).

cf_find_station("A42", search = "network", status = "all") +
cf_find_station(lat = -41.2784, long = 174.7767, rad = 10,
                search = "latlong")

# Note these are all ordered by open stations, then again by their end dates
}
}
\seealso{
\code{\link{cf_save_kml}} for saving the resulting stations as a KML
file, \code{\link{cf_station}} for creating \code{\link{cfStation}} objects
when the agent numbers are known, \code{vignette("choose-station")} for a
tutorial on finding \pkg{clifro} stations and \code{vignette("cfStation")}
for working with \code{\link{cfStation}} objects.
}
