% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{as.transactions}
\alias{as.transactions}
\title{Coerces a Clickstream Object to a Transactions Object}
\usage{
as.transactions(clickstreamList)
}
\arguments{
  \item{clickstreamList}{A list of clickstreams.}
}
\value{
An instance of the class \code{\link[arules]{transactions}}
}
\description{
Coerces a \code{Clickstream} object to a \code{transactions}
object.
}
\examples{
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
trans <- as.transactions(cls)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{frequencies}}
}

