% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{ansi_collapse}
\alias{ansi_collapse}
\title{Collapse a vector into a string scalar}
\usage{
ansi_collapse(
  x,
  sep = ", ",
  last = ", and ",
  trunc = Inf,
  width = Inf,
  ellipsis = symbol$ellipsis,
  style = c("both-ends", "head")
)
}
\arguments{
\item{x}{Character vector, or an object with an \code{as.character()} method
to collapse.}

\item{sep}{Character string, separator.}

\item{last}{Last separator, if there is no truncation. E.g. use
\code{", and "} for the Oxford comma.}

\item{trunc}{MAximum number of elements to show. For \code{sytle = "head"}
at least \code{trunc = 1} is used. For \code{style = "both-ends"} at least
\code{trunc = 5} is used, even if a smaller number is specified.}

\item{width}{Limit for the display width of the result, in characters.
This is a hard limit, and the output will never exceed it.
This argument is not implemented for the \code{"both-ends"} style, which
always uses \code{Inf}, with a warning if a fininte \code{width} value is set.}

\item{ellipsis}{character string to use at the place of the truncation.
By default the Unicode ellipsis character is used if the console is
UTF-8 and three dots otherwise.}

\item{style}{Truncation style:
\itemize{
\item \code{both-ends}: the default, shows the beginning and end of the vector,
and skips elements in the middle if needed.
\item \code{head}: shows the beginning of the vector, and skips elements at the
end, if needed.
}}
}
\value{
Character scalar. It is \code{NA_character_} if any elements in the
vector are \code{NA}.
}
\description{
Features:
}
\details{
\itemize{
\item custom separator,
\item custom last separator: \code{last} argument,
\item adds ellipsis to truncated strings,
\item uses Unicode ellipsis character on UTF-8 console,
\item can collapse "from both ends", with \code{style = "both-ends"},
\item can consider a limit for the display width of the result, in characters,
\item handles ANSI control sequences correctly when measuring dipaly width.
}
}
\examples{
ansi_collapse(letters)

# truncate
ansi_collapse(letters, trunc = 5)

# head style
ansi_collapse(letters, trunc = 5, style = "head")
}
\seealso{
\code{glue_collapse} in the glue package incpired this function
}
