% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_dl}
\alias{cli_dl}
\title{Definition list}
\usage{
cli_dl(
  items = NULL,
  id = NULL,
  class = NULL,
  .close = TRUE,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{Named character vector, or \code{NULL}. If not \code{NULL}, they
are used as list items.}

\item{id}{Id of the list container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
returned invisibly.}

\item{class}{Class of the list container. Can be used in themes.}

\item{.close}{Whether to close the list container if the \code{items} were
specified. If \code{FALSE} then new items can be added to the list.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
A definition list is a container, see \link{containers}.
}
\details{
\subsection{All items at once}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_dl(c(foo = "one", bar = "two", baz = "three"))
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{cli-dl.svg}}
}

\subsection{Items one by one}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_dl()
  cli_li(c(foo = "\{.emph one\}"))
  cli_li(c(bar = "two"))
  cli_li(c(baz = "three"))
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{cli-dl-2.svg}}
}
}
