% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_html}
\alias{ansi_html}
\title{Convert ANSI styled text to HTML}
\usage{
ansi_html(x, escape_reserved = TRUE, csi = c("drop", "keep"))
}
\arguments{
\item{x}{Input character vector.}

\item{escape_reserved}{Whether to escape characters that are reserved
in HTML (\code{&}, \code{<} and \code{>}).}

\item{csi}{What to do with non-SGR ANSI sequences, either \code{"keep"},
or \code{"drop"} them.}
}
\value{
Character vector of HTML.
}
\description{
Convert ANSI styled text to HTML
}
\examples{
\dontshow{if (cli:::has_packages(c("htmltools", "withr"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Syntax highlight the source code of an R function with ANSI tags,
## and export it to a HTML file.
code <- withr::with_options(
  list(ansi.num_colors = 256),
  code_highlight(format(ansi_html))
)
hcode <- paste(ansi_html(code), collapse = "\n")
css <- paste(format(ansi_html_style()), collapse=  "\n")
page <- htmltools::tagList(
  htmltools::tags$head(htmltools::tags$style(css)),
  htmltools::tags$pre(htmltools::HTML(hcode))
)

if (interactive()) htmltools::html_print(page)
\dontshow{\}) # examplesIf}
}
\seealso{
Other ANSI to HTML conversion: 
\code{\link{ansi_html_style}()}
}
\concept{ANSI to HTML conversion}
