% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_constants.R
\name{remove_constants}
\alias{remove_constants}
\title{Remove empty rows and columns and constant column}
\usage{
remove_constants(data, cutoff = 1L)
}
\arguments{
\item{data}{The input data frame or linelist}

\item{cutoff}{The cut-off for empty rows and columns removal. If provided,
only rows and columns where the percent of missing data is greater than
this cut-off will removed.}
}
\value{
The input dataset without the empty rows and columns and the
constant columns.
}
\description{
Remove empty rows and columns and constant column
}
\examples{
data <- readRDS(system.file("extdata", "test_df.RDS", package = "cleanepi"))

# introduce an empty column
data$empty_column <- NA

# remove the constant columns, empty rows and columns
dat <- remove_constants(
  data   = data,
  cutoff = 1
)

# check the report to see what has happened
report <- attr(dat, "report")
summary(report)
}
