% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_list.R
\name{group_list}
\alias{group_list}
\title{List groups.}
\usage{
group_list(
  offset = 0,
  limit = 31,
  sort = NULL,
  groups = NULL,
  all_fields = FALSE,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{offset}{(numeric) Where to start getting activity items from
(optional, default: 0)}

\item{limit}{(numeric) The maximum number of activities to return
(optional, default: 31)}

\item{sort}{Field to sort on. You can specify ascending (e.g., score desc) or
descending (e.g., score asc), sort by two fields (e.g., score desc, price asc),
or sort by a function (e.g., sum(x_f, y_f) desc, which sorts by the sum of
x_f and y_f in a descending order).}

\item{groups}{(character) A list of names of the groups to return, if given
only groups whose names are in this list will be returned}

\item{all_fields}{(logical) Return full group dictionaries instead of just
names. Default: \code{FALSE}}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
List groups.
}
\examples{
\dontrun{
group_list(limit = 3)
group_list(limit = 3, as = 'json')
group_list(limit = 3, as = 'table')
}
}
