#' CKAN server URLS and other info
#'
#' @export
#' @details Comes from the links at http://ckan.org/instances
#'
#' There were a number of other URLs for CKAN instances in the CKAN URL
#' above, but some sites are now gone completely, or if they do exist,
#' I can't figure out how to get access to the CKAN API on their instance.
#' @examples \dontrun{
#' servers()
#' ckan_info("http://data.gov.au/")
#' ckan_info(servers()[5])
#'
#' # what version is each CKAN server running
#' out <- lapply(servers()[1:6], ckan_info)
#' vapply(out, "[[", "", "ckan_version")
#' }
servers <- function() server_urls

server_urls <- c(
  "http://catalog.data.gov",
  "http://africaopendata.org",
  "http://annuario.comune.fi.it",
  "http://bermuda.io",
  "http://catalogue.data.gov.bc.ca",
  "http://catalogue.datalocale.fr",
  "http://ckan.gsi.go.jp",
  "http://dados.al.gov.br",
  "http://dados.gov.br",
  "http://dados.recife.pe.gov.br",
  "http://dados.rs.gov.br",
  "http://dadosabertos.senado.gov.br",
  "http://dartportal.leeds.ac.uk",
  "http://data.bris.ac.uk/data",
  "http://data.buenosaires.gob.ar",
  "http://data.cityofsantacruz.com",
  "http://data.edostate.gov.ng",
  "http://data.glasgow.gov.uk",
  "http://data.go.id",
  "http://data.gov.au",
  "http://data.gov.hr",
  "http://data.gov.ie",
  "http://data.gov.ro",
  "http://data.gov.sk",
  "http://data.gov.uk",
  "http://data.grcity.us",
  "http://data.kk.dk",
  "http://data.lexingtonky.gov",
  "http://data.london.gov.uk",
  "http://data.nantou.gov.tw",
  "http://data.openva.com",
  "http://data.ottawa.ca",
  "http://data.qld.gov.au",
  "http://data.rio.rj.gov.br",
  "http://data.sa.gov.au",
  "http://data.salzburgerland.com",
  "http://data.surrey.ca",
  "http://data.tainan.gov.tw",
  "http://data.gv.at/katalog",
  "http://data.norge.no/api/dcat/data.json",
  "http://data.nsw.gov.au/data",
  "https://data.overheid.nl/data",
  "http://catalog.data.ug",
  "http://data.vic.gov.au",
  "http://data.wu.ac.at",
  "http://data.zagreb.hr",
  "http://dataforjapan.org",
  "http://datagm.org.uk",
  "http://datahub.io",
  "http://datameti.go.jp/data",
  "http://datamx.io",
  "http://datapoa.com.br",
  "http://dati.trentino.it",
  "http://datos.codeandomexico.org",
  "http://suche.transparenz.hamburg.de",
  "http://dati.lazio.it/catalog",
  "http://dati.openexpo2015.it/catalog/it/",
  "http://dati.openexpo2015.it/catalog/en/",
  "http://dati.toscana.it",
  "http://datos.gov.py",
  "http://datosabiertos.ec",
  "http://datosabiertos.malaga.eu",
  "http://datospublicos.gob.ar",
  "http://donnees.ville.montreal.qc.ca",
  "http://donnees.ville.sherbrooke.qc.ca",
  "http://drdsi.jrc.ec.europa.eu",
  "http://etsin.avointiede.fi",
  "http://gisdata.mn.gov",
  "http://datos.santander.es/catalogo",
  "http://search.geothermaldata.org",
  "http://govdata.de/ckan",
  "http://hubofdata.ru",
  "http://iatiregistry.org",
  "http://offenedaten.de",
  "http://open.canada.ca/data/en",
  "http://opendata.aachen.de",
  "http://opendata.admin.ch",
  "http://opendata.aragon.es",
  "http://opendata.awt.be",
  "http://opendata.caceres.es",
  "http://opendata.cmt.es",
  "http://opendata.cnmc.es",
  "http://opendata.comune.bari.it",
  "http://opendata.hu",
  "http://opendata.lisra.jp",
  "http://data.opencolorado.org",
  "https://opendata.riik.ee",
  "http://opendatadc.org",
  "http://opendatagortynia.gr",
  "http://opendatahub.gr",
  "http://opendatareno.org",
  "http://opingogn.is",
  "http://oppnadata.se",
  "http://portal.openbelgium.be",
  "http://publicdata.eu",
  "http://rotterdamopendata.nl",
  "http://taijiang.tw",
  "http://www.civicdata.io",
  "http://www.daten.rlp.de",
  "http://www.datos.misiones.gov.ar",
  "http://opendatacanarias.es/datos",
  "http://www.data.go.jp/data",
  "http://www.hri.fi/fi",
  "http://www.nosdonnees.fr",
  "http://www.odaa.dk",
  "http://www.offene-daten.me",
  "http://www.opendata-hro.de",
  "http://www.opendata.provincia.roma.it",
  "http://www.opendatahub.it",
  "https://catalogodatos.gub.uy",
  "https://data.barrowbc.gov.uk",
  "https://data.glasgow.gov.uk",
  "https://data.hdx.rwlabs.org",
  "https://data.qld.gov.au",
  "https://data.sa.gov.au",
  "https://datahub.cmap.illinois.gov",
  "https://edx.netl.doe.gov",
  "https://gisdata.mn.gov",
  "https://offenedaten.de",
  "https://www.opendatabc.ca",
  "http://opendata.opennorth.se/",
  "https://data.noaa.gov",
  "https://data.overheid.nl/data",
  "https://www.data.gv.at/katalog"
)
