% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp.R
\name{het_vimp}
\alias{het_vimp}
\title{Estimate Variable Importance Metrics for \code{cjbart} Object}
\usage{
het_vimp(imces, levels = NULL, covars = NULL, cores = 1, ...)
}
\arguments{
\item{imces}{Object of class \code{cjbart}, the result of running \code{\link[=IMCE]{IMCE()}}}

\item{levels}{An optional vector of attribute-levels to generate importance metrics for. By default, all attribute-levels are analyzed.}

\item{covars}{An optional vector of covariates to include in the importance metric check. By default, all covariates are included in each importance model.}

\item{cores}{Number of CPU cores used during VIMP estimation. Each extra core will result in greater memory consumption. Assigning more cores than outcomes will not further boost performance.}

\item{...}{Extra arguments (used to check for deprecated argument names)}
}
\value{
A "long" data.frame of variable importance scores for each combination of covariates and attribute-levels, as well as the estimated 95\% confidence intervals for each metric.
}
\description{
Estimates random forest variable importance scores for multiple attribute-levels of a conjoint experiment.
}
\details{
Having generated a schedule of individual-level marginal component effect estimates, this function fits a random forest model for each attribute-level using the supplied covariates as predictors. It then calculates a variable importance measure (VIMP) for each covariate. The VIMP method assesses how important each covariate is in terms of partitioning the predicted individual-level effects distribution, and can thus be used as an indicator of which variables drive heterogeneity in the IMCEs.

To recover a VIMP measure, we used permutation-based importance metrics recovered from random forest models estimated using \code{\link[randomForestSRC:rfsrc]{randomForestSRC::rfsrc()}}. To permute the data, this function uses random node assignment, whereby cases are randomly assigned to a daughter node whenever a tree splits on the target variable \insertCite{@see @ishwaran2008random}{cjbart}. Importance is defined in terms of how random node assignment degrades the performance of the forest. Higher degradation indicates a variable is more important to prediction.

Variance estimates of each variable's importance are subsequently recovered using the delete-d jackknife estimator developed by \insertCite{ishwaran2019standard;textual}{cjbart}. The jackknife method has inherent bias correction properties, making it particularly effective for variable selection exercises such as identifying drivers of heterogeneity.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[randomForestSRC:rfsrc]{randomForestSRC::rfsrc()}} and \code{\link[randomForestSRC:subsample.rfsrc]{randomForestSRC::subsample()}}
}
