% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{queries_get}
\alias{queries_get}
\title{Get details about a query}
\usage{
queries_get(id)
}
\arguments{
\item{id}{integer required. The query ID.}
}
\value{
A list containing the following elements:
\item{id}{integer, The query ID.}
\item{database}{integer, The database ID.}
\item{sql}{string, The SQL to execute.}
\item{credential}{integer, The credential ID.}
\item{resultRows}{array, A preview of rows returned by the query.}
\item{resultColumns}{array, A preview of columns returned by the query.}
\item{scriptId}{integer, The ID of the script associated with this query.}
\item{exception}{string, Deprecated and not used.}
\item{error}{string, The error message for this run, if present.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{startedAt}{string, The start time of the last run.}
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run. One of queued, running, succeeded, failed, and cancelled.}
\item{lastRunId}{integer, The ID of the last run.}
\item{hidden}{boolean, The hidden status of the item.}
\item{archived}{string, The archival status of the requested item(s).}
\item{name}{string, The name of the query.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{reportId}{integer, The ID of the report associated with this query.}
}
\description{
Get details about a query
}
