% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_list}
\alias{imports_list}
\title{List Imports}
\usage{
imports_list(
  type = NULL,
  author = NULL,
  destination = NULL,
  source = NULL,
  status = NULL,
  hidden = NULL,
  archived = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{type}{string optional. If specified, return imports of these types. It accepts a comma-separated list, possible values are 'AutoImport', 'DbSync', 'Salesforce', 'GdocImport'.}

\item{author}{string optional. If specified, return imports from this author. It accepts a comma-separated list of author ids.}

\item{destination}{string optional. If specified, returns imports with one of these destinations. It accepts a comma-separated list of remote host ids.}

\item{source}{string optional. If specified, returns imports with one of these sources. It accepts a comma-separated list of remote host ids. 'DbSync' must be specified for 'type'.}

\item{status}{string optional. If specified, returns imports with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at, last_run.updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{name}{string, The name of the import.}
\item{syncType}{string, The type of sync to perform; one of Dbsync, AutoImport, GdocImport, GdocExport, and Salesforce.}
\item{source}{list, A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For salesforce imports, the first and only element is the client credential id. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
\item name string, 
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item remoteHostId integer, 
\item credentialId integer, 
\item additionalCredentials array, Array that holds additional credentials used for specific imports. For salesforce imports, the first and only element is the client credential id. For DB Syncs, the first element is an SSL private key credential id, and the second element is the corresponding public key credential id.
\item name string, 
}}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{id}{integer, The ID for the import.}
\item{isOutbound}{boolean, }
\item{jobType}{string, The job type of this import.}
\item{state}{string, }
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{timeZone}{string, The time zone of this import.}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List Imports
}
