% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{databases_list_tables}
\alias{databases_list_tables}
\title{List tables in the specified database, deprecated use "GET /tables" instead}
\usage{
databases_list_tables(
  id,
  name = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the database.}

\item{name}{string optional. If specified, will be used to filter the tables returned. Substring matching is supported (e.g., "name=table" will return both "table1" and "my table").}

\item{limit}{integer optional. Number of results to return. Defaults to 200. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the table.}
\item{databaseId}{integer, The ID of the database.}
\item{schema}{string, The name of the schema containing the table.}
\item{name}{string, Name of the table.}
\item{description}{string, The description of the table, as specified by the table owner}
\item{isView}{boolean, True if this table represents a view. False if it represents a regular table.}
\item{rowCount}{integer, The number of rows in the table.}
\item{columnCount}{integer, The number of columns in the table.}
\item{sizeMb}{number, The size of the table in megabytes.}
\item{owner}{string, The database username of the table's owner.}
\item{distkey}{string, The column used as the Amazon Redshift distkey.}
\item{sortkeys}{string, The column used as the Amazon Redshift sortkey.}
\item{refreshStatus}{string, How up-to-date the table's statistics on row counts, null counts, distinct counts, and values distributions are. One of: refreshing, stale, or current.}
\item{lastRefresh}{string, The time of the last statistics refresh.}
\item{refreshId}{string, The ID of the most recent statistics refresh.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
}
\description{
List tables in the specified database, deprecated use "GET /tables" instead
}
