% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{jobs_list_workflows}
\alias{jobs_list_workflows}
\title{List the workflows a job belongs to}
\usage{
jobs_list_workflows(id, archived = NULL)
}
\arguments{
\item{id}{integer required.}

\item{archived}{string optional. The archival status of the requested item(s).}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this workflow.}
\item{name}{string, The name of this workflow.}
\item{description}{string, A description of the workflow.}
\item{valid}{boolean, The validity of the workflow definition.}
\item{fileId}{string, The file id for the s3 file containing the workflow configuration.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The state of the workflow. State is "running" if any execution is running, otherwise reflects most recent execution state.}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{timeZone}{string, The time zone of this workflow.}
\item{nextExecutionAt}{string, The time of the next scheduled execution.}
\item{archived}{string, The archival status of the requested item(s).}
\item{createdAt}{string, }
\item{updatedAt}{string, }
}
\description{
List the workflows a job belongs to
}
