% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{search_list}
\alias{search_list}
\title{Perform a search}
\usage{
search_list(query = NULL, type = NULL, offset = NULL, order = NULL,
  owner = NULL, limit = NULL, archived = NULL,
  last_run_state = NULL)
}
\arguments{
\item{query}{string optional. The search query.}

\item{type}{string optional. The type for the search. It accepts a comma-separated list. Valid arguments are listed on the "GET /search/types" endpoint.}

\item{offset}{integer optional. The offset for the search results.}

\item{order}{string optional. The field on which to order the result set.}

\item{owner}{string optional. The owner for the search.}

\item{limit}{integer optional. Defaults to 10. Maximum allowed is 1000.}

\item{archived}{string optional. If specified, return only results with the chosen archived status; either 'true', 'false', or 'all'. Defaults to 'false'.}

\item{last_run_state}{string optional. The last run state of the job being searched for; either: 'queued', 'running', 'succeeded', 'failed', or 'cancelled'.}
}
\value{
An array containing the following fields:
\item{totalResults}{integer, The number of items matching the search query.}
\item{aggregations}{list, Aggregations by owner and type for the search results.}
\item{results}{array, An array containing the following fields: 
\itemize{
\item score number, The relevance score from the search request.
\item type string, The type of the item.
\item id integer, The ID of the item.
\item name string, The name of the item.
\item typeName string, The verbose name of the type.
\item updatedAt string, The time the item was last updated.
\item owner string, The owner of the item.
\item useCount integer, The use count of the item, if the item is a template.
\item lastRunId integer, The last run id of the item, if the item is a job.
\item lastRunState string, The last run state of the item, if the item is a job.
\item lastRunStart string, The last run start time of the item, if the item is a job.
\item lastRunFinish string, The last run finish time of the item, if the item is a job.
\item public boolean, The flag that indicates a template is available to all users.
\item lastRunException string, The exception of the item after the last run, if the item is a job.
}}
}
\description{
Perform a search
}
