% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{groups_list}
\alias{groups_list}
\title{List Groups}
\usage{
groups_list(query = NULL, permission = NULL, limit = NULL,
  page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{query}{string optional. If specified, it will filter the groups returned. Prefix matching is supported (e.g., "query=group" will return "group" and "group of people", but not "my group".}

\item{permission}{string optional. A permissions string, one of "read", "write", or "manage". Lists only groups for which the current user has that permission.}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this group.}
\item{name}{string, This group's name.}
\item{createdAt}{string, The date and time when this group was created.}
\item{slug}{string, The slug for this group.}
\item{organizationId}{integer, The organization associated with this group.}
}
\description{
List Groups
}
