% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_post_kubernetes_partitions}
\alias{clusters_post_kubernetes_partitions}
\title{Create a Cluster Partition for given cluster}
\usage{
clusters_post_kubernetes_partitions(id, instance_configs, name, labels)
}
\arguments{
\item{id}{integer required. The ID of the cluster which this partition belongs to.}

\item{instance_configs}{array required. An array containing the following fields: 
\itemize{
\item instanceType string, An EC2 instance type. Possible values include t2.large, m4.xlarge, m4.2xlarge, and p2.xlarge.
\item minInstances integer, The minimum number of instances of that type in this cluster.
\item maxInstances integer, The maximum number of instances of that type in this cluster.
}}

\item{name}{string required. The name of the cluster partition.}

\item{labels}{array required. Labels associated with this partition.}
}
\value{
A list containing the following elements:
\item{clusterPartitionId}{integer, The ID of this cluster partition.}
\item{name}{string, The name of the cluster partition.}
\item{labels}{array, Labels associated with this partition.}
\item{instanceConfigs}{array, An array containing the following fields: 
\itemize{
\item instanceConfigId integer, The ID of this InstanceConfig.
\item instanceType string, An EC2 instance type. Possible values include t2.large, m4.xlarge, m4.2xlarge, and p2.xlarge.
\item minInstances integer, The minimum number of instances of that type in this cluster.
\item maxInstances integer, The maximum number of instances of that type in this cluster.
\item instanceMaxMemory number, The amount of memory (RAM) available to a single instance of that type in megabytes.
\item instanceMaxCpu number, The number of processor shares available to a single instance of that type in millicores.
}}
\item{defaultInstanceConfigId}{integer, The id of the InstanceConfig that is the default for this partition.}
}
\description{
Create a Cluster Partition for given cluster
}
